<?php

namespace pictpostpersonal;

/**
 * $_FILES を扱いやすく変換するクラス
 */
class Files implements \IteratorAggregate
{
    /** @var File[] */
    private array $files = [];

    public function __construct(array $files)
    {
        foreach ($files as $field_name => $file_data) {
            if (is_array($file_data['name'])) {
                // 複数ファイルアップロードの場合
                $count = count($file_data['name']);
                for ($i = 0; $i < $count; $i++) {
                    $this->files[] = new File([
                        'name' => $file_data['name'][$i],
                        'type' => $file_data['type'][$i],
                        'tmp_name' => $file_data['tmp_name'][$i],
                        'error' => $file_data['error'][$i],
                        'size' => $file_data['size'][$i],
                    ]);
                }
            } else {
                // 単一ファイルアップロードの場合
                $this->files[] = new File($file_data);
            }
        }
    }

    public function getIterator(): \Traversable
    {
        return new \ArrayIterator($this->files);
    }

    public function all(): array
    {
        return $this->files;
    }

    public function get($index): ?File
    {
        return $this->files[$index] ?? null;
    }

    public function count(): int
    {
        return count($this->files);
    }
}
