<?php

namespace pictpostpersonal;

use pictpostpersonal\model\Setting;
use pictpostpersonal\Authentification;
use pictpostpersonal\service\ThemeService;

/**
 * 依存性注入コンテナ
 *
 * HTTPリクエスト情報と依存性注入を分離し、型安全な依存性管理を実現する
 */
class Context
{
    private \PDO $db;
    private Setting $setting;
    private ThemeService $theme;
    private Authentification $auth;
    private Logger $log;

    /**
     * コンストラクタ
     *
     * @param \PDO $db
     * @param Setting $setting
     * @param ThemeService $theme
     * @param Authentification $auth
     * @param Logger $log
     */
    public function __construct(
        \PDO $db,
        Setting $setting,
        ThemeService $theme,
        Authentification $auth,
        Logger $log
    ) {
        $this->db = $db;
        $this->setting = $setting;
        $this->theme = $theme;
        $this->auth = $auth;
        $this->log = $log;
    }

    /**
     * データベース接続を取得
     *
     * @return \PDO
     */
    public function getDb(): \PDO
    {
        return $this->db;
    }

    /**
     * 設定情報を取得
     *
     * @return Setting
     */
    public function getSetting(): Setting
    {
        return $this->setting;
    }

    /**
     * テーマサービスを取得
     *
     * @return ThemeService
     */
    public function getTheme(): ThemeService
    {
        return $this->theme;
    }

    /**
     * 認証システムを取得
     *
     * @return Authentification
     */
    public function getAuth(): Authentification
    {
        return $this->auth;
    }

    /**
     * ロガーを取得
     *
     * @return Logger
     */
    public function getLog(): Logger
    {
        return $this->log;
    }
}
