<?php

namespace pictpostpersonal;

spl_autoload_register(function ($class) {
	// ベースディレクトリ
	$base_dir = __DIR__;

	// クラス名をファイルパスに変換
	$class = str_replace(__NAMESPACE__ . '\\', '', $class);
	$class_path = str_replace('\\', '/', $class) . '.php';

	//汎用クラス ( /core/class )を検索
	$file = "$base_dir/class/$class_path";
	if (file_exists($file)) {
		require_once $file;
		return;
	}

	// namespaceと合致するパスのファイルがあればそれを利用
	$file = "$base_dir/$class_path";
	if (file_exists($file)) {
		require_once $file;
		return;
	}

	// サブディレクトリを検索
	$sub_base_dir = dirname($file);
	$iterator = new \RecursiveIteratorIterator(
		new \RecursiveDirectoryIterator($sub_base_dir, \RecursiveDirectoryIterator::SKIP_DOTS),
		\RecursiveIteratorIterator::LEAVES_ONLY
	);
	foreach ($iterator as $file) {
		if ($file->getFilename() === basename($class_path)) {
			require_once $file->getPathname();
			return;
		}
	}

	// クラスファイルが見つからない場合はエラー
	throw new \Exception("Class file for '{$class}' not found.");
});
